﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public partial class Administration : BaseComponent
    {
        protected class StudentListPanel : AdminPanel
        {
            public StudentListPanel(Administration Component) : base(Component) { }

            public override void Load()
            {
                if (Component.Instructor != null)
                {
                    Component.XML.Element.Start("StudentList");
                    List<BL.BO.Student> _listStudent = Component.BLELearning.Student.Restore(Component.Instructor);
                    HashSet<long> _classIDs = new HashSet<long>();
                    foreach (BL.BO.Student _loopStudent in _listStudent)
                    {
                        Component.AppendToXML(_loopStudent);
                        if (!_classIDs.Contains(_loopStudent.ClassID.Value))
                        {
                            _classIDs.Add(_loopStudent.ClassID.Value);
                        }
                    }
                    Component.XML.Element.End();

                    Component.XML.Element.Start("ClassList");
                    foreach (long _loopClassID in _classIDs)
                    {
                        Component.AppendToXML(Component.BLELearning.Class.RestoreById(_loopClassID));
                    }
                    Component.XML.Element.End();
                }
            }

            public override bool Save()
            {
                if (StudentID.HasValue && EditMode == EditModeType.GenerateCertificate)
                {
                    BL.BO.Student _student = Component.BLELearning.Student.Restore(StudentID);
                    if (_student != null)
                    {
                        PI.ZB.N1200.ELearning.BL.PDFReport.GenerateStudentCert(_student, Component.Environment);
                    }
                }
                return true;
            }
        }
    }
}